@section('title') 
Home - Januardi Logistik
@endsection 
@extends('layout')
@section('style')
  <style>
    @media screen and (min-width: 1000px) {
      .header-title {
        font-size: 46px !important;
      }
    }
    img.vert-move {
        -webkit-animation: mover 2s ease-in-out infinite alternate;
        animation: mover 2s ease-in-out infinite alternate;
    }
    @-webkit-keyframes mover {
        0% { transform: translateY(0); }
        100% { transform: translateY(-20px); }
    }
    @keyframes mover {
        0% { transform: translateY(0); }
        100% { transform: translateY(-20px); }
    }
  </style>
@endsection 
@section('content')

    <!-- ======= Hero Section ======= -->
  <section id="hero" class="hero d-flex align-items-center" style="min-height: 680px;">
    <div class="container">
      <div class="row gy-4 d-flex justify-content-between">
        <div class="col-lg-6 order-2 order-lg-1 d-flex flex-column justify-content-center text-center text-md-start px-3 px-md-5">
          <h1 data-aos="fade-up" class="mb-4 text-capitalize" style="color: white; font-weight: 600; line-height: 65px; font-size: 50px;">Your solutions to all your shipping needs</h1>
            <p data-aos="fade-up" data-aos-delay="100" class="mb-1 text-capitalize" style="color: #9094A2; font-weight: 400; line-height: 32px; font-size: 16px;">
              We believe in our commitments to perfectly shipping in all areas of transportation 
            </p>

          <div class="mt-4" data-aos="fade-up" data-aos-delay="200">
            <a href="{{ url('/get-in-touch') }}" class="btn btn-primary rounded-pill p-3 px-5 fw-bold fs-5">
              Get In Touch
            </a>
          </div>
        </div>

        <div class="col-lg-6 order-1 order-lg-2 hero-img" data-aos="zoom-out">
          <img src="{{ asset('assets/img/undraw_container_ship_re_alm4.svg') }}" class="img-fluid mb-3 mb-lg-0 vert-move" styele="animation: float 6s ease-in-out infinite;" alt="Image-Hero">
        </div>

      </div>
    </div>
  </section><!-- End Hero Section -->

  <main id="main">
    <img src="{{ asset('assets/img/1216474_972-removebg-preview.png') }}" alt="pattern" style="z-index:-100 !important; position: absolute; opacity: 0.08; right: 0;">
    <!-- ======= About Us Section ======= -->
    <section id="about" class="about">
      <div class="container" data-aos="fade-up">

        <div class="section-header">
          <span>About Us</span>
          <h2>About Us</h2>

        </div>

        <div class="row gy-4">
          <div class="col-lg-6 position-relative align-self-start order-lg-last order-first" data-aos="fade-up" data-aos-delay="300">
            <img src="{{ asset('assets/img/jlog_banner.png') }}" class="img-fluid rounded w-100" alt="Profile">
          </div>
          <div class="col-md-6 content order-last  order-lg-first">
            <p style="text-indent: 10%;" data-aos="fade-up" data-aos-delay="100">
              Januardi Logistik was established in 1999 with a mission to 
              provide reliable and efficient forwarding services for our customers 
              in the global markets. During the operation, we serve the needs of 
              Indonesian importers and exporters in a reliable and professional manner.
            </p>
            <p style="text-indent: 10%;" data-aos="fade-up" data-aos-delay="200">
              Over the years we have been handling a very large varieties of goods. 
              Your goods may not be too long, too big, or too small, they will always be taken care of. 
              Our Services focused on <b>Air Freight, Sea Freight, Customs Clearance & PPJK, Export & Import</b>.
            </p>
            <h4 class="mb-3 pt-3 fw-bold" style="color : #001f8d" data-aos="fade-up" data-aos-delay="300">Why Choose Us?</h4>
            <ul>
              <li data-aos="fade-up" class="align-items-center mt-2" data-aos-delay="300">
                <i class="bi bi-check2-circle me-3" style="font-size: 26px !important"></i>
                <div>
                  <p>Experienced Since 1999</p>
                </div>
              </li>
              <li data-aos="fade-up" class="align-items-center mt-2" data-aos-delay="400">
                <i class="bi bi-check2-circle me-3" style="font-size: 26px !important"></i>
                <div>
                  <p>Professional Team</p>
                </div>
              </li>
              <li data-aos="fade-up" class="align-items-center mt-2" data-aos-delay="500">
                <i class="bi bi-check2-circle me-3" style="font-size: 26px !important"></i>
                <div>
                  <p>Reliable Price</p>
                </div>
              </li>
              <li data-aos="fade-up" class="align-items-center mt-2" data-aos-delay="600">
                <i class="bi bi-check2-circle me-3" style="font-size: 26px !important"></i>
                <div>
                  <p>Member of Associate Global Network</p>
                </div>
              </li>
            </ul>
          </div>
        </div>

      </div>
    </section><!-- End About Us Section -->

    <!-- ======= Services Section ======= -->
    <img src="{{ asset('assets/img/1216474_972-removebg-preview-kanan.png') }}" alt="pattern" style="z-index:-100 !important; position: absolute; opacity: 0.08;">
    <section id="service" class="services pt-0">
      <div class="container" data-aos="fade-up">

        <div class="section-header">
          <span>Our Services</span>
          <h2>Our Services</h2>

        </div>

        <div class="row gy-4">

          <div class="col-lg-3 col-md-6" data-aos="fade-right" data-aos-delay="100">
            <div class="card rounded">
              <div class="card-img">
                <img src="{{ asset('assets/img/international-air-freight-an-overview-shipping-solutions2.jpg') }}" alt="Air Freight" class="img-fluid rounded-top">
              </div>
              <h3><a href="{{ url('/air-freight') }}" class="stretched-link">Air Freight</a></h3>
              <p>
                Air Freight is one of the main services provided by PT Januardi Logistik since 1999. We provide services with easy delivery throughout the world with well-maintained security.
            </p>
            </div>
          </div><!-- End Card Item -->

          <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="200">
            <div class="card rounded">
              <div class="card-img">
                <img src="{{ asset('assets/img/CAF-Blog-What-Is-Freight-Forwarding.jpg') }}" alt="Sea Freight" class="img-fluid rounded-top">
              </div>
              <h3><a href="{{ url('/sea-freight') }}" class="stretched-link">Sea Freight</a></h3>
              <p>
                Sea freight is one of the freight forwarding services provided by PT Januardi Logistik since 1999. PT Januardi Logistik offers a comprehensive range of services to meet even the simplest or most diverse needs.
              </p>
            </div>
          </div><!-- End Card Item -->

          <div class="col-lg-3 col-md-6" data-aos="fade-down" data-aos-delay="300">
            <div class="card rounded">
              <div class="card-img">
                <img src="{{ asset('assets/img/July-small-freight-forwarders-1420x550.jpg') }}" alt="Customs Clearance & PPJK" class="img-fluid rounded-top">
              </div>
              <h3><a href="{{ url('/customs-clearance') }}" class="stretched-link">Customs Clearance & PPJK</a></h3>
              <p>
                PT Januardi Logistik has fulfilled the resource requirements and has complete legality and a custom broker licenses making it easier for your customs processes.
              </p>
            </div>
          </div><!-- End Card Item -->

          <div class="col-lg-3 col-md-6" data-aos="fade-left" data-aos-delay="400">
            <div class="card rounded">
              <div class="card-img">
                <img src="{{ asset('assets/img/Import-Export-5-2-2022.jpg') }}" alt="Export & Import" class="img-fluid rounded-top">
              </div>
              <h3><a href="{{ url('/export-import') }}" class="stretched-link">Export & Import</a></h3>
              <p>
                Export and Import services are one of the services of PT Januardi Logistik. We are ready to help take care of all administrative needs needed.
              </p>
            </div>
          </div><!-- End Card Item -->

          <!-- <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="400">
            <div class="card">
              <div class="card-img">
                <img src="{{ asset('assets/img/trucking-service.jpg') }}" alt="" class="img-fluid">
              </div>
              <h3><a href="service-details.html" class="stretched-link">Trucking</a></h3>
              <p>Dicta quam similique quia architecto eos nisi aut ratione aut ipsum reiciendis sit doloremque oluptatem aut et molestiae ut et nihil</p>
            </div>
          </div> -->
          <!-- End Card Item -->

          <!-- <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="500">
            <div class="card">
              <div class="card-img">
                <img src="{{ asset('assets/img/packaging-service.jpg') }}" alt="" class="img-fluid">
              </div>
              <h3><a href="service-details.html" class="stretched-link">Packaging</a></h3>
              <p>Illo consequuntur quisquam delectus praesentium modi dignissimos facere vel cum onsequuntur maiores beatae consequatur magni voluptates</p>
            </div>
          </div> -->
          <!-- End Card Item -->

          <!-- <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="600">
            <div class="card">
              <div class="card-img">
                <img src="{{ asset('assets/img/warehousing-service.jpg') }}" alt="" class="img-fluid">
              </div>
              <h3><a href="service-details.html" class="stretched-link">Warehousing</a></h3>
              <p>Quas assumenda non occaecati molestiae. In aut earum sed natus eatae in vero. Ab modi quisquam aut nostrum unde et qui est non quo nulla</p>
            </div>
          </div> -->
          <!-- End Card Item -->

        </div>

      </div>
    </section><!-- End Services Section -->

    <!-- ======= Vision and Mission Section ======= -->
    <img src="{{ asset('assets/img/1216474_972-removebg-preview.png') }}" alt="pattern" style="z-index:-100 !important; position: absolute; opacity: 0.08; right: 0;">
    <section id="features" class="features pb-5 pt-0">
      <div class="container">

        <div class="section-header">
          <span>Our Vision and Mission</span>
          <h2>Our Vision and Mission</h2>
        </div>

        <div class="row gy-4 justify-content-center text-center" data-aos="fade-up" data-aos-delay="100">
          <h5 class="lead px-2 px-md-5">Become the provide a vast range of reliable and efficient freight forwarding services for customers in the millennial and global market.</h5>
        </div>

        <div class="row gy-4 justify-content-center text-center mt-4 mx-0">
          <div class="col-md-4 px-5" data-aos="fade-right" data-aos-delay="100">
            <img src="{{ asset('assets/img/number-1.png') }}" alt="number" class="img-fluid">
            <p class="lead mt-3">
              Be the best solution in delivery service
            </p>
          </div>
          <div class="col-md-4 px-5" data-aos="fade-up" data-aos-delay="200">
            <img src="{{ asset('assets/img/rating.png') }}" alt="rating" class="img-fluid">
            <p class="lead mt-3">
              Provide freight forwarding service by prioritizing customer satisfaction
            </p>
          </div>
          <div class="col-md-4 px-5" data-aos="fade-left" data-aos-delay="300">
            <img src="{{ asset('assets/img/global-network.png') }}" alt="global network" class="img-fluid">
            <p class="lead mt-3">
              Maintain and have good relations with the global network in several countries
            </p>
          </div>
        </div>

      </div>
    </section><!-- End Vision and Mission Section -->

    <!-- ======= Call To Action Section ======= -->
    <section id="call-to-action" class="call-to-action">
      <div class="container" data-aos="zoom-out">

        <div class="row justify-content-center">
          <div class="col-lg-8 text-center">
            <h3>Get In Touch</h3>
            <p>
              We Provide a Vast Range of Reliable and Efficient Freight Forwarding Services. <br> 
              Please click this button to Get In Touch with us and fill in your shipping details to get the best offers from us!
            </p>
            <a class="cta-btn" href="{{ url('/get-in-touch') }}">Get In Touch</a>
          </div>
        </div>

      </div>
    </section><!-- End Call To Action Section -->

    <!-- ======= Gallery Section ======= -->
    <img src="{{ asset('assets/img/1216474_972-removebg-preview-kanan.png') }}" alt="pattern" style="z-index:-100 !important; position: absolute; opacity: 0.08;">
    <section id="gallery" class="gallery mt-0 pt-0 pb-5">
      <div class="container" data-aos="fade-up">

        <div class="section-header">
          <span>Gallery</span>
          <h2>Gallery</h2>

        </div>

        <div class="row gy-4 justify-content-center">
          <div class="col-xl-3 col-lg-4 col-md-6" data-aos="zoom-in" data-aos-delay="100">
            <div class="gallery-item h-100">
              <img src="{{ asset('assets/img/gallery/7.jpeg') }}" class="img-fluid" alt="">
              <div class="gallery-links d-flex align-items-center justify-content-center">
                <a href="{{ asset('assets/img/gallery/7.jpeg') }}" title="Project Open Top Container" class="glightbox preview-link"><i class="bi bi-arrows-angle-expand"></i></a>
                <!-- <a href="gallery-single.html" class="details-link"><i class="bi bi-link-45deg"></i></a> -->
              </div>
            </div>
          </div><!-- End Gallery Item -->
          <div class="col-xl-3 col-lg-4 col-md-6" data-aos="zoom-in" data-aos-delay="200">
            <div class="gallery-item h-100">
              <img src="{{ asset('assets/img/gallery/8.jpeg') }}" class="img-fluid" alt="">
              <div class="gallery-links d-flex align-items-center justify-content-center">
                <a href="{{ asset('assets/img/gallery/8.jpeg') }}" title="Project Open Top Container" class="glightbox preview-link"><i class="bi bi-arrows-angle-expand"></i></a>
                <!-- <a href="gallery-single.html" class="details-link"><i class="bi bi-link-45deg"></i></a> -->
              </div>
            </div>
          </div><!-- End Gallery Item -->
          <div class="col-xl-3 col-lg-4 col-md-6" data-aos="zoom-in" data-aos-delay="300">
            <div class="gallery-item h-100">
              <img src="{{ asset('assets/img/gallery/1.jpeg') }}" class="img-fluid" alt="">
              <div class="gallery-links d-flex align-items-center justify-content-center">
                <a href="{{ asset('assets/img/gallery/1.jpeg') }}" title="AIO Logistic Conference at Bangkok, Thailand" class="glightbox preview-link"><i class="bi bi-arrows-angle-expand"></i></a>
                <!-- <a href="gallery-single.html" class="details-link"><i class="bi bi-link-45deg"></i></a> -->
              </div>
            </div>
          </div><!-- End Gallery Item -->
          <div class="col-xl-3 col-lg-4 col-md-6" data-aos="zoom-in" data-aos-delay="400">
            <div class="gallery-item h-100">
              <img src="{{ asset('assets/img/gallery/9.jpeg') }}" class="img-fluid" alt="">
              <div class="gallery-links d-flex align-items-center justify-content-center">
                <a href="{{ asset('assets/img/gallery/9.jpeg') }}" title="Project Open Top Container" class="glightbox preview-link"><i class="bi bi-arrows-angle-expand"></i></a>
                <!-- <a href="gallery-single.html" class="details-link"><i class="bi bi-link-45deg"></i></a> -->
              </div>
            </div>
          </div><!-- End Gallery Item -->
        </div>

      </div>
    </section><!-- End Gallery Section -->

    <!-- ======= Network Section ======= -->
    <img src="{{ asset('assets/img/1216474_972-removebg-preview.png') }}" alt="pattern" style="z-index:-100 !important; position: absolute; opacity: 0.08; right: 0;">
    <section id="network" class="network pt-0 pb-5">
      <div class="container" data-aos="fade-up">

        <div class="section-header">
          <span>Member Of</span>
          <h2>Member Of</h2>

        </div>

        <div class="network-slider swiper" data-aos="zoom-in" data-aos-delay="100">
          <div class="swiper-wrapper align-items-center">
            <div class="swiper-slide"><img src="{{ asset('assets/img/network/1.png') }}" class="img-fluid" alt=""></div>
            <div class="swiper-slide"><img src="{{ asset('assets/img/network/2.png') }}" class="img-fluid" alt=""></div>
            <div class="swiper-slide"><img src="{{ asset('assets/img/network/3.png') }}" class="img-fluid" alt=""></div>
            <div class="swiper-slide"><img src="{{ asset('assets/img/network/4.png') }}" class="img-fluid" alt=""></div>
            <div class="swiper-slide"><img src="{{ asset('assets/img/network/5.png') }}" class="img-fluid" alt=""></div>
          </div>
          <div class="swiper-pagination"></div>
        </div>

      </div>
    </section>
    <!-- End Network Section -->

  </main><!-- End #main -->

@endsection 