@section('title') 
Get In Touch - Januardi Logistik
@endsection 
@extends('layout')
@section('style')

@endsection 
@section('content')

<main id="main">

    <!-- ======= Breadcrumbs ======= -->
    <div class="breadcrumbs">
      <div class="page-header d-flex align-items-center" style="background-image: url({{ asset('assets/img/cover-2.jpg')}});">
        <div class="container position-relative">
          <div class="row d-flex justify-content-center">
            <div class="col-lg-6 text-center">
              <h2>Get in Touch</h2>
              <p>JLOG is ready to help you! Please fill in your shipping details below to get the best offers from us!</p>
            </div>
          </div>
        </div>
      </div>
      <nav>
        <div class="container">
          <ol>
            <li><a href="{{ url('/') }}">Home</a></li>
            <li>Get in Touch</li>
          </ol>
        </div>
      </nav>
    </div><!-- End Breadcrumbs -->

    <!-- ======= Contact Section ======= -->
    <img src="{{ asset('assets/img/1216474_972-removebg-preview-kanan.png') }}" alt="pattern" style="z-index:-100 !important; position: absolute; opacity: 0.08;">
    <section id="contact" class="contact">
      <div class="container" data-aos="fade-up">

        <div>
          <iframe style="border:0; width: 100%; height: 340px;" src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d15829.142160470104!2d112.7419129!3d-7.3217889!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x1fc6a0c0e4c98430!2sPT.%20JANUARDI%20LOGISTIK!5e0!3m2!1sen!2sid!4v1669613613669!5m2!1sen!2sid" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade" frameborder="0" ></iframe>
        </div><!-- End Google Maps -->

        <div class="row gy-4 mt-4">
            
            @if(Session::has('status'))
                <div class="alert alert-success">{{ Session::get('status') }}</div>
            @endif

          <div class="col-lg-4">

            <div class="info-item d-flex">
              <i class="bi bi-geo-alt flex-shrink-0"></i>
              <div>
                <h4>Location:</h4>
                <p>Jemursari VI/7, Surabaya 60237, Indonesia</p>
              </div>
            </div><!-- End Info Item -->

            <div class="info-item d-flex">
              <i class="bi bi-envelope flex-shrink-0"></i>
              <div>
                <h4>Email:</h4>
                <p>marketing@j-logistik.com</p>
              </div>
            </div><!-- End Info Item -->

            <div class="info-item d-flex">
              <i class="bi bi-phone flex-shrink-0"></i>
              <div>
                <h4>Call:</h4>
                <p>+62 31 8420558</p>
              </div>
            </div><!-- End Info Item -->

          </div>

          <div class="col-lg-8">
            <form action="{{ url('/send-email') }}" method="post" role="form" class="php-email-form">
                {{ csrf_field() }}
              <div class="row">
                <div class="col-md-6 form-group">
                  <input type="text" name="name" class="form-control" id="name" placeholder="Your Name" required>
                </div>
                <div class="col-md-6 form-group mt-3 mt-md-0">
                  <input type="text" class="form-control" name="company" id="company" placeholder="Your Company" required>
                </div>
              </div>
              <div class="row mt-3">
                <div class="col-md-6 form-group">
                  <input type="text" name="phone" class="form-control" id="phone" placeholder="Your Phone Number" required>
                </div>
                <div class="col-md-6 form-group mt-3 mt-md-0">
                  <input type="email" class="form-control" name="email" id="email" placeholder="Your Email" required>
                </div>
              </div>
              <div class="form-group mt-3">
                <input type="text" class="form-control" name="subject" id="subject" placeholder="Subject" required>
              </div>
              <div class="form-group mt-3">
                <textarea class="form-control" name="message" rows="5" placeholder="Message" required></textarea>
              </div>
              <div class="my-3">
                <div class="loading">Loading</div>
                <div class="error-message"></div>
                <div class="sent-message">Your message has been sent. Thank you!</div>
              </div>
              <div class="text-center"><button type="submit">Send Message</button></div>
            </form>
          </div><!-- End Contact Form -->

        </div>

      </div>
    </section><!-- End Contact Section -->
    <img src="{{ asset('assets/img/1216474_972-removebg-preview.png') }}" alt="pattern" style="z-index:-100 !important; position: absolute; opacity: 0.08; right: 0;">
    
  </main><!-- End #main -->

@endsection 